<?php

/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.2.6 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('node', [
  'fields' => [
    'nid' => [
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'vid' => [
      'type' => 'int',
      'not null' => FALSE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ],
    'type' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '32',
      'default' => '',
    ],
    'language' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '12',
      'default' => '',
    ],
    'title' => [
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ],
    'uid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'status' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '1',
    ],
    'created' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'changed' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'comment' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'promote' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'sticky' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
    'tnid' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ],
    'translate' => [
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
    ],
  ],
  'primary key' => [
    'nid',
  ],
  'unique keys' => [
    'vid' => [
      'vid',
    ],
  ],
  'indexes' => [
    'node_changed' => [
      'changed',
    ],
    'node_created' => [
      'created',
    ],
    'node_frontpage' => [
      'promote',
      'status',
      'sticky',
      'created',
    ],
    'node_status_type' => [
      'status',
      'type',
      'nid',
    ],
    'node_title_type' => [
      'title',
      [
        'type',
        '4',
      ],
    ],
    'node_type' => [
      [
        'type',
        '4',
      ],
    ],
    'uid' => [
      'uid',
    ],
    'tnid' => [
      'tnid',
    ],
    'translate' => [
      'translate',
    ],
    'language' => [
      'language',
    ],
  ],
  'mysql_character_set' => 'utf8mb3',
]);

$connection->insert('node')
  ->fields([
    'nid',
    'vid',
    'type',
    'language',
    'title',
    'uid',
    'status',
    'created',
    'changed',
    'comment',
    'promote',
    'sticky',
    'tnid',
    'translate',
  ])
  ->values([
    'nid' => '1',
    'vid' => '1',
    'type' => 'article',
    'language' => 'und',
    'title' => 'Article one',
    'uid' => '1',
    'status' => '0',
    'created' => '1647492702',
    'changed' => '1647492702',
    'comment' => '2',
    'promote' => '1',
    'sticky' => '0',
    'tnid' => '0',
    'translate' => '0',
  ])
  ->values([
    'nid' => '2',
    'vid' => '2',
    'type' => 'article',
    'language' => 'und',
    'title' => 'Article two',
    'uid' => '1',
    'status' => '0',
    'created' => '1647492753',
    'changed' => '1647492753',
    'comment' => '2',
    'promote' => '1',
    'sticky' => '0',
    'tnid' => '0',
    'translate' => '0',
  ])
  ->values([
    'nid' => '3',
    'vid' => '3',
    'type' => 'article',
    'language' => 'und',
    'title' => 'Article three',
    'uid' => '1',
    'status' => '1',
    'created' => '1647492779',
    'changed' => '1647492779',
    'comment' => '2',
    'promote' => '1',
    'sticky' => '0',
    'tnid' => '0',
    'translate' => '0',
  ])
  ->execute();
