/**
 * @file
 * Hero Slider functionality.
 */

(function heroSlider(Drupal, once) {
  Drupal.behaviors.heroSlider = {
    attach: function attach(context) {
      var slider = once(
        'hero-slider',
        document.querySelector('#image-carousel'),
        context,
      );

      const splide = new Splide('.splide', {
        pagination: false,
        type: 'fade',
        rewind: true,
        autoplay: true,
        interval: 3000,
        speed: 800,
        breakpoints: {
          1024: {
            arrows: false,
          },
        },
      });

       // Hide arrows if there is only one slide
        splide.on('mounted', function () {
          if (splide.length === 1) {
            splide.options = { arrows: false };
            //document.querySelector('.splide__arrows').style.display = 'none';
          }
        });

        splide.mount();
    },
  };
})(Drupal, once);
