/**
 * @file
 * Videos functionality.
 */

(function video(Drupal, once) {
  Drupal.behaviors.video = {
    attach: function attach(context) {
      var remoteVideos = once(
        "remote-video",
        document.querySelectorAll(".media--type-remote-video"),
        context
      );

      // foreach video element, add a play button and a click event listener
      remoteVideos.forEach(function (video) {
        // select a inner div element
        var playButtonImage = video.querySelector("a");

        playButtonImage.addEventListener("click", function () {
          var iframe = video.querySelector("iframe");
          var videoSrc = iframe.getAttribute("src");

          playButtonImage.remove();
          // TODO: play the video
          // console.log(videoSrc);
        });
      });

      // Event for all bootstap popups when close to stop the video
      // https://getbootstrap.com/docs/4.0/components/modal/#events
      var modals = document.querySelectorAll(".modal");
      modals.forEach(function (modal) {
        modal.addEventListener("hidden.bs.modal", function () {
          var iframe = modal.querySelector("iframe");
          var videoSrc = iframe.getAttribute("src");
          // console.log(videoSrc);
          iframe.setAttribute("src", "");
        });
      });
    },
  };
})(Drupal, once);
