# DNA Legal Theme

A custom Drupal 11 theme with a component-based workflow using Gulp.

## Requirements

- Node.js 16+
- npm 8+
- Drupal 11

## Getting Started

1. Navigate to the theme directory:
   ```
   cd web/themes/custom/dna
   ```

2. Install dependencies:
   ```
   npm install
   ```

3. Start development server:
   ```
   npm start
   ```

## Available Commands

- `npm start` - Run development workflow with live reloading
- `npm run build` - Build optimized assets for production
- `npm run clean` - Remove all generated files (.min.css, .min.js, .map)

## Theme Structure

```
dna/
├── components/          # Component organization
│   └── header/          # Example component
│       ├── src/         # Source files
│       │   ├── header.scss
│       │   └── header.js
│       ├── header.css   # Compiled CSS
│       ├── header.js    # Processed JS
│       └── header.twig  # Template
├── src/                 # Theme-level source files
│   ├── sass/            # Theme SCSS files
│   │   ├── theme.scss
│   │   └── _config.scss
│   └── js/              # Theme JS files
├── dist/                # Theme-level compiled assets
│   ├── css/             # Compiled theme CSS
│   └── js/              # Compiled theme JS
├── node_modules/
├── gulpfile.js          # Gulp configuration
├── package.json
└── README.md
```

## Development Workflow

- Edit component files in `components/*/src` directories
- Edit theme-level files in `src/sass` and `src/js` directories
- Gulp watches for changes and automatically:
  - Compiles SCSS to CSS
  - Processes JavaScript
  - Refreshes the browser

### Component Workflow
- Component source files are stored in their respective component folder under `src/`
- Compiled files are output to the root of the component folder

### Theme-Level Workflow
- Theme-level SCSS files in `src/sass` are compiled to `dist/css`
- Theme-level JS files in `src/js` are compiled to `dist/js`

## Production Build

The production build process:
1. Creates any missing directories in the structure
2. Cleans previously generated files
3. Compiles and minifies SCSS to CSS
4. Processes and uglifies JavaScript
5. Creates both regular and minified (.min) versions of files

## Local Development

- Disable Drupal caching through settings.local.php for live reloading
- Ensure CSS/JS aggregation is disabled in development
