"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Transform = exports.Readable = exports.Writable = exports.ObjectTransform = void 0;
const ObjectTransform_1 = require("./ObjectTransform");
Object.defineProperty(exports, "ObjectTransform", { enumerable: true, get: function () { return ObjectTransform_1.ObjectTransform; } });
const stream_1 = require("stream");
Object.defineProperty(exports, "Writable", { enumerable: true, get: function () { return stream_1.Writable; } });
Object.defineProperty(exports, "Readable", { enumerable: true, get: function () { return stream_1.Readable; } });
Object.defineProperty(exports, "Transform", { enumerable: true, get: function () { return stream_1.Transform; } });
const CombinedStream_1 = require("./CombinedStream");
__exportStar(require("./EnteredArgs"), exports);
__exportStar(require("./EndedArgs"), exports);
class Default {
    static transform(args) {
        return new ObjectTransform_1.ObjectTransform(args);
    }
    static combineStreams(...streams) {
        return new CombinedStream_1.CombinedStream(streams);
    }
    static combineStreamsList(streams) {
        return new CombinedStream_1.CombinedStream(streams);
    }
    static fromArray(array) {
        let i = 0;
        let stream = new ReadableObjectsStream(() => {
            if (i == array.length) {
                return null;
            }
            return array[i++];
        });
        return stream;
    }
}
exports.default = Default;
class ReadableObjectsStream extends stream_1.Readable {
    constructor(readObject) {
        super({ objectMode: true });
        this.readObject = readObject;
    }
    _read() {
        let shouldPushMore = true;
        while (shouldPushMore) {
            shouldPushMore = this.push(this.readObject());
        }
    }
}
