/// <reference types="node" />
import { EventEmitter } from "events";
export declare class CombinedStream extends EventEmitter implements NodeJS.ReadWriteStream {
    private streams;
    private first;
    private last;
    constructor(streams: NodeJS.ReadWriteStream[]);
    private pipeStreams;
    private propegateFirstAndLastEvents;
    private propegateEvents;
    get readable(): boolean;
    read(size?: number): string | Buffer;
    setEncoding(encoding: BufferEncoding): this;
    pause(): this;
    resume(): this;
    isPaused(): boolean;
    pipe<T extends NodeJS.WritableStream>(destination: T, options?: {
        end?: boolean;
    }): T;
    unpipe<T extends NodeJS.WritableStream>(destination?: T): this;
    unshift(chunk: string | Buffer): void;
    wrap(oldStream: NodeJS.ReadableStream): this;
    [Symbol.asyncIterator](): AsyncIterableIterator<string | Buffer>;
    get writable(): boolean;
    write(buffer: Uint8Array | string, cb?: (err?: Error | null) => void): boolean;
    write(str: string, encoding?: BufferEncoding, cb?: (err?: Error | null) => void): boolean;
    end(cb?: () => void): void;
    end(data: string | Uint8Array, cb?: () => void): void;
    end(str: string, encoding?: BufferEncoding, cb?: () => void): void;
}
