(function ($, Drupal) {
  Drupal.behaviors.dnaBehavior = {
    attach: function (context, settings) {
      $(once('dnaBehavior', 'body', context)).each(function () {
        const urlParams = new URLSearchParams(window.location.search);

        urlParams.forEach((value, key) => {
          const element = document.getElementById(key);
          if (element) {
            if (element.tagName === 'SELECT') {
              const optionExists = Array.from(element.options).some(option => option.value === value);
              if (optionExists) {
                element.value = value;
              }
            } else {
              element.value = value;
            }
          }
        });
      });
    }
  };
})(jQuery, Drupal);
