"use client";

import { useState } from "react";
import styles from "./chatbot.module.scss";
import { IoClose, IoSend } from "react-icons/io5";
import Image from "next/image";

export default function Chatbot() {
  const [chatbotOpen, setChatbotOpen] = useState<boolean>(false);
  const [showChatbot, setShowChatbot] = useState<boolean>(false);
  const [newMessage, setNewMessage] = useState<string>();
  const helloMessage = "Hello there! 👋 It's nice to meet you!";
  const [messages, setMessages] = useState<MessageInterface[]>([
    { sender: "Chatbot", message: helloMessage },
  ]);
  const [loading, setLoading] = useState<boolean>(false);
  //Local
  const sendChatbotStatus = (message: string) => {
    window.parent.postMessage(message, "https://knowbo-clone.xgate.io");
  };

  const sendMessage = () => {
    setMessages((prev) => [
      ...prev,
      { sender: "You", message: newMessage || "" },
    ]);
    setNewMessage("");
    setLoading(true);
    setTimeout(() => {
      setLoading(false);
      setMessages((prev) => [
        ...prev,
        { sender: "Chatbot", message: "Automated reply" },
      ]);
    }, 900);
  };

  const toggleChatbot = () => {
    if (!chatbotOpen) {
      setChatbotOpen(true);
      sendChatbotStatus("chatbot-open");
      setTimeout(() => {
        setShowChatbot(true);
      }, 200); // this must be the same with the css transition delay
    } else {
      setShowChatbot(false);
      setTimeout(() => {
        sendChatbotStatus("chatbot-closed");
        setChatbotOpen(false);
      }, 200); // this must be the same with the css transition delay
    }
  };

  return (
    <div className={styles.chatbotWrapper}>
      {chatbotOpen ? (
        <div className={`${styles.chat} ${showChatbot ? styles.showChat : ""}`}>
          <div className={styles.chatInner}>
            <div className={styles.header}>
              <Image
                width={60}
                height={50}
                src={"/robot.png"}
                alt="robot-img"
              />
              <div>
                <div className={styles.headerText}>ChatBot</div>
                <div className={styles.status}>Online</div>
              </div>
              <IoClose className={styles.closeButton} onClick={toggleChatbot} />
            </div>
            <div className={styles.main}>
              {messages.map((message, index) => (
                <div
                  className={`${styles.chatBubble} ${message.sender === "You" ? styles.user : ""}`}
                  key={"chatbot-message-" + index}
                >
                  <div className={styles.messageSender}>{message.sender}</div>
                  <div className={styles.message}>
                    <p>{message.message}</p>
                  </div>
                </div>
              ))}
              {loading && (
                <div className={styles.chatBubble}>
                  <div className={styles.messageSender}>Chatbot</div>
                  <div className={styles.message}>
                    <div className={styles.typingLoading}>
                      <div className={styles.dot}></div>
                      <div className={styles.dot}></div>
                      <div className={styles.dot}></div>
                    </div>
                  </div>
                </div>
              )}
            </div>
            <div className={styles.typing}>
              <input
                type="text"
                placeholder="Type your message here"
                value={newMessage}
                onChange={(e) => setNewMessage(e.target.value)}
              />
              <div className={styles.sendIconWrapper}>
                <IoSend
                  className={`${styles.sendIcon} ${newMessage ? styles.active : ""}`}
                  onClick={sendMessage}
                />
              </div>
            </div>
            <div className={styles.footer}>
              <div>Powered by XGate-AI</div>
            </div>
          </div>
        </div>
      ) : (
        ""
      )}
      <div
        className={`${styles.chatbotButtonWrapper} ${!!showChatbot ? styles.chatbotButtonHide : ""}`}
      >
        <div className={styles.chatbotButton} onClick={toggleChatbot} />
      </div>
    </div>
  );
}

interface MessageInterface {
  sender: string;
  message: string;
}
